/*:
 * @target MZ
 * @plugindesc Tooltip line-reset patch — ツールチップを行単位で再描画し、\FS 等の影響持ち越しでアイコンがズレる問題を解消
 * @author HS
 * @help
 * MEG_PictureTooltipMZ v1.5 以降対応。プラグイン管理で必ず後に配置してください。
 */
(() => {
  'use strict';

  // Scene_Map 生成後に、ツールチップ窓の描画関数を差し替える
  const _createAllWindows = Scene_Map.prototype.createAllWindows;
  Scene_Map.prototype.createAllWindows = function() {
    _createAllWindows.apply(this, arguments);
    const w = this._hoverTooltip;
    if (!w || w._hsLineResetPatched) return;
    w._hsLineResetPatched = true;

    // 幅計測も行ごとにフォントをリセット
    w._measureMultiline = function(text) {
      const lines = String(text ?? "").split(/\r?\n/);
      let maxW = 0;
      for (const l of lines) {
        this.resetFontSettings();                 // ← ここがポイント
        const sz = this.textSizeEx(l);
        maxW = Math.max(maxW, Math.ceil(sz.width));
      }
      const h = this.fittingHeight(Math.max(1, lines.length));
      return { w: maxW, h };
    };

    // 再描画は1行ずつフォントをリセットして描く
    w._redrawText = function(text) {
      this.contents.clear();
      const lines = String(text ?? "").split(/\r?\n/);
      for (let i = 0; i < lines.length; i++) {
        this.resetFontSettings();                 // ← ここがポイント
        this.contents.fontBold = true;
        this.drawTextEx(lines[i], 0, i * this.lineHeight());
      }
    };
  };
})();
